/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8285.DeviceView.BayLike;
import ibm.nways.jdm8285.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8285.DeviceView.LeafCompositeLike;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Bay
implements BayLike {
    protected int numberOfPorts;
    protected int bayIndex;
    protected int slot;
    protected String gifName = "";
    protected int bayType;
    protected int modType;
    protected int mediaType;
    protected GraphicContainer moduleContainer;
    protected String destinationPanel;
    protected GenModel portModel;
    protected Point location;
    protected GraphicContainer bayContainer = new GraphicContainer();
    private Vector components = new Vector();
    protected String cookieID;
    protected ChassisInfoLike chassis;
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8285.DeviceView.GraphicResources";
    protected static final String SER_PATH = "ibm.nways.jdm8285.WCDefault";
    protected static final int COOKIE_FLAGS = 22;

    public void dispose() {
        String string = "dispose (Bay)";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        this.portModel = null;
        this.location = null;
        this.moduleContainer = null;
        this.chassis = null;
        if (this.bayContainer != null) {
            this.bayContainer.dispose();
            this.bayContainer = null;
        }
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public void draw() {
        String string = "draw (Bay)";
        if (RAS.isEnabled(19, 6)) {
            RAS.enter(19, 6, this, string);
        }
        WidgetCookie widgetCookie = new WidgetCookie(this.cookieID, BUNDLE_NAME, null, SER_PATH, null, this.chassis.getBrowser(), 22, null);
        this.bayContainer.add((GraphicContainer)widgetCookie);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            leafCompositeLike.draw();
        }
        this.moduleContainer.add(this.bayContainer);
        if (RAS.isEnabled(19, 6)) {
            RAS.exit(19, 6, this, string);
        }
    }

    public void discoverChildren() {
    }

    public int getNumberOfPorts() {
        return this.numberOfPorts;
    }

    public static int getWANBayType(int n, int n2) {
        switch (n) {
            case 4: {
                switch (n2) {
                    case 2: {
                        return 100108;
                    }
                    case 3: {
                        return 100109;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            case 6: {
                switch (n2) {
                    case 6: {
                        return 100110;
                    }
                    case 7: {
                        return 100111;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            case 8: {
                switch (n2) {
                    case 4: {
                        return 100107;
                    }
                    case 5: {
                        return 100106;
                    }
                }
            }
        }
        return 0;
    }

    public static int get155BayType(int n, int n2) {
        switch (n) {
            case 4: {
                switch (n2) {
                    case 2: {
                        return 132;
                    }
                    case 3: {
                        return 126;
                    }
                    default: {
                        return 0;
                    }
                }
            }
            case 7: {
                switch (n2) {
                    case 4: 
                    case 5: {
                        return 133;
                    }
                    case 6: {
                        return 134;
                    }
                }
            }
        }
        return 0;
    }

    public static int getACEBayType(int n, int n2) {
        switch (n) {
            case 1: {
                switch (n2) {
                    case 4: {
                        return 100104;
                    }
                    case 8: {
                        return 100105;
                    }
                }
                return 1;
            }
            case 2: {
                switch (n2) {
                    case 4: {
                        return 100102;
                    }
                    case 8: {
                        return 100103;
                    }
                }
                return 1;
            }
        }
        return 2;
    }

    public final void setCommonInformation(ChassisInfoLike chassisInfoLike, int n, int n2, int n3, Point point, GraphicContainer graphicContainer, int n4, String string, GenModel genModel) {
        this.chassis = chassisInfoLike;
        this.slot = n;
        this.bayIndex = n2;
        this.mediaType = n3;
        this.location = point;
        this.moduleContainer = graphicContainer;
        this.modType = n4;
        this.portModel = genModel;
        this.destinationPanel = string;
        this.bayContainer.setLocation(point.x, point.y);
    }

    public void setSpecificInformation() {
    }
}

